# Gotchas:
# $xyx, $(xyz), ${xyz} and %xyx indicate variables to be replaced at runtime, please do NOT translate variable names
# & in button labels such as accessibility denotes the quick access letter
# buttons are fixed in length, so please make sure the translated strings will fit

# MAIN PAGE
LangString UseCD ${LANG_TRADCHINESE} "(ϥCD)"
LangString ReadOnly ${LANG_TRADCHINESE} "uŪ"
LangString MainHeaderSubText ${LANG_TRADCHINESE} "ЬsbJΤWMKX"
LangString MainLanguageLabel ${LANG_TRADCHINESE} "Language:"
LangString MainUsernameLabel ${LANG_TRADCHINESE} "Username:"
LangString MainPasswordLabel ${LANG_TRADCHINESE} "Password:"
LangString MainInstallationSizeLabel ${LANG_TRADCHINESE} "Installation Size (GB):"
LangString MainDistroLabel ${LANG_TRADCHINESE} "Desktop Environment:"
LangString MainInstallationDriveLabel ${LANG_TRADCHINESE} "Installation Drive ($freeSpace GB free):"

# TOOLTIPS
LangString MainLanguageToolTip ${LANG_TRADCHINESE} "Installation language."
LangString MainUsernameToolTip ${LANG_TRADCHINESE} "Please select a username for the new account.$\r$\nIt must be lower case.$\r$\nIt must not contain spaces.$\r$\nIt must contain only standard letters and numbers.$\r$\nIt cannot start by a number."
LangString MainPasswordToolTip ${LANG_TRADCHINESE} "Please select a password for the new account.$\r$\nIt must not contain spaces."
LangString MainInstallationSizeToolTip ${LANG_TRADCHINESE} "How many GB do you want to allocate?$\r$\n4GB is the bare minimum$\r$\n8GB is comfortable"
LangString MainInstallationDriveToolTip ${LANG_TRADCHINESE} "In which drive do you want to perform the installation?$\r$\nThis drive should have at least 5 GB free."
LangString Distro1ToolTip ${LANG_TRADCHINESE} "Ubuntu is the default."
LangString Distro2ToolTip ${LANG_TRADCHINESE} "Kubuntu uses the KDE3.5 desktop."
LangString Distro3ToolTip ${LANG_TRADCHINESE} "Kubuntu-KDE4 uses the KDE4 desktop."
LangString Distro4ToolTip ${LANG_TRADCHINESE} "Xubuntu is good for older systems."
LangString MainDistroToolTip ${LANG_TRADCHINESE} "What graphical environment do you want to install?$\r$\n* $(Distro1ToolTip)$\r$\n* $(Distro2ToolTip)$\r$\n* $(Distro3ToolTip)$\r$\n* $(Distro4ToolTip)"

# ERRORS
LangString ErrorNoUsername ${LANG_TRADCHINESE} "Please enter a valid username"
LangString ErrorSpaceInUsername ${LANG_TRADCHINESE} "Please do not use spaces in the username."
LangString ErrorUsernameUpperCase ${LANG_TRADCHINESE} "Please use all lower cases in the username."
LangString ErrorUsernameFirstCharNotLetter ${LANG_TRADCHINESE} "Your username must start with a letter."
LangString ErrorUsernameIllegalChars ${LANG_TRADCHINESE} "Your username must contain only standard letters and numbers."
LangString ErrorReservedUsername ${LANG_TRADCHINESE} "The selected username is reserved, please selected a different one."
LangString ErrorNoPassword ${LANG_TRADCHINESE} "Please enter a valid password."
LangString ErrorPasswordMismatch ${LANG_TRADCHINESE} "Passwords do not match."
LangString ErrorSpaceInPassword ${LANG_TRADCHINESE} "Please do not use spaces in the password."
LangString ErrorNoFreeSpace ${LANG_TRADCHINESE} "Not enough free space."
LangString ErrorNoKernel ${LANG_TRADCHINESE} "Could not retrieve some essential files"
LangString ErrorBcdedit ${LANG_TRADCHINESE} "Error while trying to execute bcdedit:"
LangString ErrorWubibcd ${LANG_TRADCHINESE} "Error while trying to execute wubibcd:"
LangString ErrorCD2ISO ${LANG_TRADCHINESE} "Could not access the CD, please make sure other applications are not using it and try again"
LangString ErrorDownload ${LANG_TRADCHINESE} "The download was interrupted with the error:"
LangString ErrorNoCD ${LANG_TRADCHINESE} "Could not find any appropriate CD"
LangString ErrorNoAdmin ${LANG_TRADCHINESE} "You must be logged in as administrator!"
LangString ErrorNoMemory ${LANG_TRADCHINESE} "You need at least ${MinMemoryMB}MB of memory to run the installer!"

# INSTALLER
LangString AboutToInstall ${LANG_TRADCHINESE} "You are about to install $Distro-$DistroVersion"
LangString InstallHeaderInitializing ${LANG_TRADCHINESE} "Installing $Distro-$DistroVersion"
LangString InstallSubHeader ${LANG_TRADCHINESE} "Please wait while the required files are retrieved and prepared"
LangString InstallHeaderUncompressWubifolder ${LANG_TRADCHINESE} "Uncompressing wubi folder..."
LangString InstallHeaderCopyIso ${LANG_TRADCHINESE} "Copying installation files..."
LangString InstallHeaderDownload ${LANG_TRADCHINESE} "Retrieving installation files, resume supported"
LangString InstallHeaderBackupIso ${LANG_TRADCHINESE} "Backing up installation files..."
LangString InstallHeaderWritePreseed ${LANG_TRADCHINESE} "Writing configuration files..."
LangString InstallHeaderWriteUninstaller ${LANG_TRADCHINESE} "Setting up uninstaller..."
LangString InstallHeaderWriteBootLoader ${LANG_TRADCHINESE} "Setting up bootloader..."
LangString InstallGenerateVirtualDisks ${LANG_TRADCHINESE} "Creating virtual disks..."
LangString InstallCopyFiles ${LANG_TRADCHINESE} "Copying installation files..."
LangString InstallCreateFolders ${LANG_TRADCHINESE} "Creating folders..."
LangString InstallRetrieveIso ${LANG_TRADCHINESE} "Retrieving installation files."

# UNINSTALLER
LangString UninstallAlreadyInstalled ${LANG_TRADCHINESE} "${AppName} is already installed"
LangString UninstallAsk ${LANG_TRADCHINESE} "Do you want to uninstall it?"
LangString UninstallMessageField ${LANG_TRADCHINESE} "$OldInstallationDrive\${DefaultInstallationDir} will be uninstalled.$\r$\nYou can backup your files if you want."
LangString UninstallBackupIsoCheckBox ${LANG_TRADCHINESE} "Backup downloaded files (CD ISO file)."
LangString UninstallBackupHomeCheckBox ${LANG_TRADCHINESE} "Backup personal documents (home.disk)."
LangString UninstallBackupLocationField ${LANG_TRADCHINESE} "Backup location: $BackupFolder"

# FINISH
LangString EjectRebootMsg ${LANG_TRADCHINESE} "Please remove any CD/DVD and reboot to complete the installation."
LangString RebootMsg ${LANG_TRADCHINESE} "You need to reboot to complete the installation."

# DOWNLOADER
LangString MetadlDownloading ${LANG_TRADCHINESE} "Downloading installation files..."
LangString MetadlChecking ${LANG_TRADCHINESE} "Checking installation files..."
LangString MetadlConnecting ${LANG_TRADCHINESE} "Connecting to %s..."
LangString MetadlInitializing ${LANG_TRADCHINESE} "Initializing..."
LangString MetadlChecksums ${LANG_TRADCHINESE} "Calculating checksums..."
LangString MetadlRetrying1 ${LANG_TRADCHINESE} "Retrying in %d seconds... (%d of %d)"
LangString MetadlRetrying2 ${LANG_TRADCHINESE} "Retrying in %d seconds..."
LangString MetadlSecond ${LANG_TRADCHINESE} "second"
LangString MetadlSeconds ${LANG_TRADCHINESE} "seconds"
LangString MetadlProgress ${LANG_TRADCHINESE} "%s (%d%%) of %s @ %s/s"
LangString MetadlRemaining ${LANG_TRADCHINESE} " (%s remaining)"
LangString PleaseConnect ${LANG_TRADCHINESE} "Please connect to the internet now."

# ACCESSIBILITY
LangString MobilityAids ${LANG_TRADCHINESE} "Mobility Aids"
LangString VisibilityAids ${LANG_TRADCHINESE} "Visibility Aids"
LangString AccessibilityButton ${LANG_TRADCHINESE} "&Accessibility"
LangString AccessibilityText ${LANG_TRADCHINESE} "Accessibility profile"
LangString AccessibilitySubText ${LANG_TRADCHINESE} "Please select the appropriate accessibility profile"
LangString NoAccessibility ${LANG_TRADCHINESE} "None"
LangString VisibilityHighContrast ${LANG_TRADCHINESE} "High Contrast"
LangString VisibilityMagnifier ${LANG_TRADCHINESE} "Magnifier"
LangString VisibilityScreenReader ${LANG_TRADCHINESE} "Screen Reader"
LangString VisibilityBraille ${LANG_TRADCHINESE} "Braille Terminal"
LangString MobilityKeyboardModifiers ${LANG_TRADCHINESE} "Keyboard Modifiers"
LangString MobilityOnScreenKeyboard ${LANG_TRADCHINESE} "On-Screen Keyboard"

# CDBOOT
LangString CDBootTitle ${LANG_TRADCHINESE} "Install CD booter"
LangString CDBootText ${LANG_TRADCHINESE} "If your machine cannot boot off the CD, this program will install a new boot menu entry to help you boot from CD. In most cases this program is not needed, and it is sufficient to reboot with the CD-Rom in the tray.$\r$\n$\r$\nDo you want to proceed and install the CD booter?"

# BOOTMENU
LangString BootMenuNormal ${LANG_TRADCHINESE} "Start installer in normal mode"
LangString BootMenuSafeGraphics ${LANG_TRADCHINESE} "Start installer in safe graphic mode (only if you have display problems)"
LangString BootMenuACPI ${LANG_TRADCHINESE} "Start installer with ACPI workarounds (only if you have ACPI problems)"
LangString BootMenuVerbose ${LANG_TRADCHINESE} "Start installer in verbose mode"

# FAILURE-COMMAND
LangString FailureCommand ${LANG_TRADCHINESE} "The installation failed. Logs have been saved in: $INSTDIR\installation-logs.zip.$\r$\n$\r$\nNote that in verbose mode, the logs may include the password.$\r$\n$\r$\nThe system will now reboot."
