var gDescriptionField = null;
var gExtensionField   = null;
var gMIMEField        = null;
var gAppPath          = null;
var gPrefApplicationsBundle = null;
function Startup()
{
  doSetOKCancel(onOK);
  gDescriptionField = document.getElementById("description");
  gExtensionField   = document.getElementById("extensions");
  gMIMEField        = document.getElementById("mimeType");
  gAppPath          = document.getElementById("appPath");
  gPrefApplicationsBundle = document.getElementById("bundle_prefApplications");
  if ( "arguments" in window && window.arguments[0] ) {
      var info = window.arguments[0].mLauncher.MIMEInfo;
      gDescriptionField.value = info.Description;
      gExtensionField.value   = info.primaryExtension;
      gMIMEField.value        = info.MIMEType;
      // an app may have been selected in the opening dialog but not in the mimeinfo
      var app = info.preferredApplicationHandler || window.arguments[0].chosenApp;
      if ( app ) {
          gAppPath.value      = app.path;
      }
      gMIMEField.setAttribute( "readonly", "true" );
      gAppPath.focus();
  } else {
      gDescriptionField.focus();
  }
  sizeToContent();
  moveToAlertPosition();
}
function chooseApp()
{
  const nsIFilePicker = Components.interfaces.nsIFilePicker;
  var filePicker = Components.classes["@mozilla.org/filepicker;1"].createInstance(nsIFilePicker);
  if (filePicker) {
    const FP = Components.interfaces.nsIFilePicker
    var windowTitle = gPrefApplicationsBundle.getString("chooseHandler");
    var programsFilter = gPrefApplicationsBundle.getString("programsFilter");
    filePicker.init(window, windowTitle, FP.modeOpen);
    if (navigator.platform == "Win32")
      filePicker.appendFilter(programsFilter, "*.exe; *.com");
    else
      filePicker.appendFilters(FP.filterAll);
    var filePicked = filePicker.show();
    if (filePicked == nsIFilePicker.returnOK && filePicker.file) {
      var file = filePicker.file.QueryInterface(Components.interfaces.nsILocalFile);
      gAppPath.value = file.path;
      gAppPath.select();
    }
  }
}
var gDS = null;
function onOK()
{
  if ( !checkInput() ) {
    return false;
  }
  const mimeTypes = "UMimTyp";
  var fileLocator = Components.classes["@mozilla.org/file/directory_service;1"].getService(Components.interfaces.nsIProperties);
  var file = fileLocator.get(mimeTypes, Components.interfaces.nsIFile);
  var ioService = Components.classes["@mozilla.org/network/io-service;1"].getService(Components.interfaces.nsIIOService);
  var fileHandler = ioService.getProtocolHandler("file").QueryInterface(Components.interfaces.nsIFileProtocolHandler);
  gDS = gRDF.GetDataSource(fileHandler.getURLSpecFromFile(file));
  gMIMEField.value = gMIMEField.value.toLowerCase();
  var exists = mimeHandlerExists(gMIMEField.value);
  if (exists) {
    var titleMsg = gPrefApplicationsBundle.getString("handlerExistsTitle");
    var dialogMsg = gPrefApplicationsBundle.getString("handlerExists");
    dialogMsg = dialogMsg.replace(/%mime%/g, gMIMEField.value);
    var promptService = Components.classes["@mozilla.org/embedcomp/prompt-service;1"].getService(Components.interfaces.nsIPromptService);
    var replace = promptService.confirm(window, titleMsg, dialogMsg);
    if (!replace)
    {
      window.close();
      return false;
    }
  }
  var handlerInfo = new HandlerOverride(MIME_URI(gMIMEField.value));
  handlerInfo.mUpdateMode = exists;
  handlerInfo.mimeType = gMIMEField.value;
  handlerInfo.description = gDescriptionField.value;
  var extensionString = gExtensionField.value.replace(/[*.;]/g, "").toLowerCase();
  var extensions = extensionString.split(" ");
  for (var i = 0; i < extensions.length; i++) {
    var currExtension = extensions[i];
    handlerInfo.addExtension(currExtension);
  }
  handlerInfo.appPath = gAppPath.value;
  handlerInfo.isEditable = true;
  handlerInfo.saveToDisk = false;
  handlerInfo.handleInternal = false;
  handlerInfo.alwaysAsk = true;
  file = Components.classes["@mozilla.org/file/local;1"].createInstance();
  if (file)
    file = file.QueryInterface(Components.interfaces.nsILocalFile);
  if (file) {
    try {
      file.initWithPath(gAppPath.value);
      handlerInfo.appDisplayName = file.leafName;
    }
    catch(e) {
      handlerInfo.appDisplayName = gAppPath.value;    
    }
  }
  handlerInfo.buildLinks();
  var remoteDS = gDS.QueryInterface(Components.interfaces.nsIRDFRemoteDataSource);
  if (remoteDS)
    remoteDS.Flush();
  if ( "arguments" in window && window.arguments[0] ) {
      var info = window.arguments[0].mLauncher.MIMEInfo;
      info.preferredAction = Components.interfaces.nsIMIMEInfo.useHelperApp;
      info.Description = gDescriptionField.value;
      info.preferredApplicationHandler = file;
      info.applicationDescription = handlerInfo.appDisplayName;
      window.arguments[0].updateSelf = true;
  }
  window.opener.gNewTypeRV = gMIMEField.value;
  window.close();  
  return false;
}