/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is NewsFox.
 *
 * The Initial Developer of the Original Code is
 * Andy Frank <andy@andyfrank.com>.
 * Portions created by the Initial Developer are Copyright (C) 2005-2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Andrey Gromyko <andrey@gromyko.name>
 *   Ron Pruitt <wa84it@gmail.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the LGPL or the GPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

////////////////////////////////////////////////////////////////
// Global
////////////////////////////////////////////////////////////////

const iconOk = "chrome://newsfox/skin/images/feed.png";
const folderOpen  = "chrome://newsfox/skin/images/folderOpen.png";
const folderClosed  = "chrome://newsfox/skin/images/folderClosed.png";
const iconErr = "chrome://newsfox/skin/images/brokenFeed.png";
var model = new Model();

////////////////////////////////////////////////////////////////
// Model
////////////////////////////////////////////////////////////////

function Model()
{
  this.add  = function(feed,isExcluded)
  {
    if (isExcluded) 
      feeds.push(feed);
    else
      feeds.splice(model.size(),0,feed); 
  }
  this.get  = function(index) { return feeds[index]; }
	this.set  = function(index, feed)
	{
		if(index < 0 || index > feeds.length - 1)
			return;
		feeds[index] = feed;
	}
  this.getFeedByURL  = function(url)
	{
		for(var i=0; i < feeds.length; i++)
			if(url == feeds[i].url)
				return feeds[i];

		return null;
	}

  this.size = function() // returns size without excluded feed(s)	
	{
		var size = 0;
		for( var i = 0; i < feeds.length; i++ )
			if( !feeds[i].exclude )
				size++;
		return size;
	}

  this.sizeTotal = function() // returns total size, i.e. with excluded from seeing feed(s)
	{
		return feeds.length;
	}

  var feeds = new Array();

  /**
   * Return a new unique uid.
   */
  this.makeUniqueUid = function(url)
  {
    var index  = url.indexOf("://");
		var body;
		if( index > -1 )
			if (url.charAt(index+3) == "/")  //  file:///
				body = "local";
			else
				body = url.substring(index+3);
		else
			body = url;
    var domain = body;
		if( body.indexOf("/") != -1 )
			domain = body.split("/")[0];
		if( domain.indexOf(":") != -1 )
			domain = domain.split(":")[0]; // there are cases when port number follows domain name
    var count = 1;
    var name = domain;
    for (var i=0; i<feeds.length; i++)
    {
      if (name == feeds[i].uid)
      {
        name = domain + (count++);
        i = -1; // reset loop
      }
    }
    return name;
  }

  /**
   * Remove the given feed from the model.
   */
  this.remove = function(feed)
  {
    for (var i=0; i < feeds.length; i++)
      if (feed.uid == feeds[i].uid)
      {
        feeds.splice(i,1);
        return;
      }
  }
}

////////////////////////////////////////////////////////////////
// Group Model
////////////////////////////////////////////////////////////////

function FeedGroup()
{
  this.title = document.getElementById("newsfox-string-bundle").getString('newGroup');
  this.expanded = false;
  this.list = new Array();
  this.getUnread = function()
  {
    var unread = 0;
    for (var i=0; i<this.list.length; i++)
      unread += model.get(this.list[i]).getUnread(0);
    return unread;
  }
}

////////////////////////////////////////////////////////////////
// Feed Model
////////////////////////////////////////////////////////////////

function Feed()
{
  this.uid = null;
  this.url = null;
  this.homepage = null;
	this.icon = new Image;
	this.icon.src = iconOk;
  this.defaultName = null;
  this.customeName = null;
  this.error = ERROR_OK;
  this.loaded = false;
  this.deleteOld = true;
  this.dontDeleteUnread = true;
  this.autoCheck = true;
  var categories = new Array();
	this.exclude = false;

  // 0 Use global setting
  // 1 Override to show as text
  // 2 Override to show as webpage
  // 3 Override to show as newspaper
  this.style = 0;
  this.getStyle = function()
  {
    if (this.style == 0)
      return options.globalStyle;
    return this.style;
  }

  /**
   * Return display name for feed.
   */
  this.getDisplayName = function()
  {
    return ((this.customName != null) && (this.customName.length > 0)) ? this.customName : this.defaultName;
  }

  this.setDefaultName = function(dname)
  {
    this.defaultName = encodeString(dname);
  }

  this.getCustomName = function()
  {
    return this.customName;
  }

  this.setCustomName = function(cname)
  {
    this.customName = encodeString(cname);
  }

  /**
   * Return the number of unread items for this feed.
   */
  this.getUnread = function(nCategory)
  {
    var unread = 0;
    for (var i=0; i<this.flags.length; i++)
      if ((this.flags[i] & 0x01) == 0) // unread
      {
        if( nCategory == 0 )
          unread++;
        else if (articles[i].category == categories[nCategory-1])
          unread++;
      }
    return unread;
  }

  this.add = function(article)
  {
    // AG: uniform add
    // articles.push(article);
    this.addExisting(article);
    this.flags.push(0);   // unread, unflagged
  }

  this.addExisting = function(article)
  {
    articles.push(article);
    // AG: added category
    if(article.category != "")
      this.addCategory(article.category);
  }

  this.deletedaddExisting = function(article)
  {
    deletedarticles.push(article);
  }

  this.get = function(index)
  {
    return articles[index];
  }

  this.deletedget = function(index)
  {
    return deletedarticles[index];
  }

  this.set = function(index,item)
  {
    articles[index] = item;
  }

  this.remove = function(index)
  {
    articles.splice(index,1);
    this.flags.splice(index,1);
  }

  this.deletedremove = function(index)
  {
    deletedarticles.splice(index,1);
  }

  this.getIndexByURL = function(url)
  {
		for(var i=0; i < articles.length; i++)
			if(url == articles[i].link)
				return i;
		return -1;
  }

  this.deleteByURL = function(url)
  {
    var index = this.getIndexByURL(url);
    if( index >= 0 && index < articles.length)
		{
    	deletedarticles.push(articles[index]);
			articles.splice(index,1);
			this.flags.splice(index,1);
		}
  }

  this.size = function() { return articles.length; }
  this.deletedsize = function() { return deletedarticles.length; }
  var articles = new Array();
  var deletedarticles = new Array();

  // Flags
  this.flags = new Array();

  this.isRead = function(index)
  {
    return ((this.flags[index] & 0x01) != 0);
  }
  this.setRead = function(index, value)
  {
    if (value) this.flags[index] |= 0x01;
    else this.flags[index] &= 0xFE;
  }

  this.isFlagged = function(index)
  {
    return ((this.flags[index] & 0x04) != 0);
  }
  this.setFlagged = function(index, value)
  {
    if (value) this.flags[index] |= 0x04;
    else this.flags[index] &= 0xFB;
  }

  // AG: added categories
  this.addCategory = function(category)
  {
    // check if a category is already in the list
    for (var i=0; i<categories.length; i++)
      if (categories[i] == category) return;

    categories.push(category);
  }
  this.getCategories = function() { return categories; }
  this.sortCategories = function() { categories.sort(); }
}

////////////////////////////////////////////////////////////////
// Article Model
////////////////////////////////////////////////////////////////

function Article()
{
  this.link  = null;
  this.title = null;
  this.body  = null;
  this.date  = null;
  // AG: added category
  this.category  = null;
}

////////////////////////////////////////////////////////////////
// Collections
////////////////////////////////////////////////////////////////

// AG: categoryNo isn't an index. 0 means root (or whole feed)
function NormalCollection(index, categoryNo, isDisplayed)
{
	this.type = 1;  // feed
	if (categoryNo > 0) this.type = 2;
	var feed = model.get(index);
  this.feed = feed;
	if (isDisplayed)
	{
		var title = entityDecode(feed.getDisplayName());
		var hasHomepage = (feed.homepage != "");
		setFeedbarButtons(this.type,title,hasHomepage);
	}
  var items = new Array();
	var itemFeed = new Array();
	var itemIndex = new Array();
  var categoryName;
  var art;
  if (categoryNo > 0)
  {
    var categories = feed.getCategories();
    categoryName = categories[categoryNo - 1];
  }
  for (var i=0; i<feed.size(); i++)
		if (categoryNo < 1)
		{
		  items.push(feed.get(i));
			itemFeed.push(index);
			itemIndex.push(i);
		}
		else
		{
		  art = feed.get(i);
		  if( art.category == categoryName )
			{
		    items.push(art);
				itemFeed.push(index);
				itemIndex.push(i);
			}
		}
  this.get  = function(index) { return items[index]; }
  this.size = function() { return items.length; }
	this.isRead = function(row) { return feed.isRead(itemIndex[row]); }
	this.setRead = function(row,value) { feed.setRead(itemIndex[row],value); }
	this.isFlagged = function(row) { return feed.isFlagged(itemIndex[row]); }
	this.setFlagged = function(row,value)
		{ feed.setFlagged(itemIndex[row],value); }
	this.getFeed = function(index) { return feed; }
	this.artSort = function(by,dir)
		{ artSort(by,dir,feed,items,itemFeed,itemIndex,this.type); }
}

function GroupCollection(grpindex)
{
	this.grpindex = grpindex;
	this.type = 0;
	var grp = feedGroup[grpindex];
	var grpHeading = document.getElementById("newsfox-string-bundle").getString('grpName');
  var title = grpHeading + " " + entityDecode(grp.title);
	setFeedbarButtons(this.type,title,false);
  var items = new Array();
	var itemIndex = new Array();
	var itemFeed = new Array();
  var art, feed, nFeed;
  for (var i=0; i<grp.list.length; i++)
	{
		nFeed = grp.list[i];
		feed = model.get(nFeed);
		for (var j=0; j<feed.size(); j++)
			{
		  	items.push(feed.get(j));
				itemIndex.push(j);
				itemFeed.push(nFeed);
			}
	}

	this.artSort = function(by,dir)
		{ artSort(by,dir,feed,items,itemFeed,itemIndex,this.type); }

	this.artSort("date","descending");

  this.get  = function(index) { return items[index]; }
  this.size = function() { return items.length; }
	this.isRead = function(row) { return model.get(itemFeed[row]).isRead(itemIndex[row]); }
	this.setRead = function(row,value) { model.get(itemFeed[row]).setRead(itemIndex[row],value); }
	this.isFlagged = function(row) { return model.get(itemFeed[row]).isFlagged(itemIndex[row]); }
	this.setFlagged = function(row,value)
		{ model.get(itemFeed[row]).setFlagged(itemIndex[row],value); }
	this.getFeed = function(index) { return model.get(itemFeed[index]); }
}

function EmptyCollection()
{
	var items = new Array();
	this.type = -1;  // empty
	setFeedbarButtons(this.type,"?",false);
  this.size = function() { return items.length; }
}

function setFeedbarButtons(type,title,hasHomepage)
{
  var feedbarTitle = document.getElementById("feedTitle");
	feedbarTitle.value = title;
  var feedbarHome = document.getElementById("feedbarHome");
	feedbarHome.setAttribute("disabled",false);
	if (!hasHomepage) feedbarHome.setAttribute("disabled",true);
  var feedbarRefresh = document.getElementById("feedbarRefresh");
	feedbarRefresh.setAttribute("disabled",false);
	if (type == 2 || type == -1) feedbarRefresh.setAttribute("disabled",true);
  var feedbarMarkread = document.getElementById("feedbarMarkread");
	feedbarMarkread.setAttribute("disabled",false);
	if (type == -1) feedbarMarkread.setAttribute("disabled",true);
  var feedbarMarkunread = document.getElementById("feedbarMarkunread");
	feedbarMarkunread.setAttribute("disabled",false);
	if (type == -1) feedbarMarkunread.setAttribute("disabled",true);
  var feedbarDelete = document.getElementById("feedbarDelete");
	feedbarDelete.setAttribute("disabled",false);
	if (type == -1) feedbarDelete.setAttribute("disabled",true);
  var feedbarOptions = document.getElementById("feedbarOptions");
	feedbarOptions.setAttribute("disabled",false);
	if (type == 2 || type == -1) feedbarOptions.setAttribute("disabled",true);
}

///////////////////////////////////////////////////////////
// AG: check model against livemarks. Returns an array, possibly empty.
function getNewLivemarks()
{
	var allLivemarks = liveBookmarks.getAllUnique();
	var allLivemarksLen = allLivemarks.length;
	var newLivemarks = new Array();
	var modelTotalSize = model.sizeTotal();
	for( var k=0; k < allLivemarksLen; k++ )
	{
		var livemark = allLivemarks[k];
		var isNew = true;
		for( var i=0; i < modelTotalSize; i++ )
			if( model.get(i).url == livemark.URL)
			{
				isNew = false;
				break;
			}

		if( isNew )
			newLivemarks.push(livemark);
	}

	return newLivemarks;
}

////////////////////////////////////////////////////////////
/////   Sorting
///////////////////////////////////////////////////////////

function artSort(by,dir,feed,items,itemFeed,itemIndex,type) 
{
// sorter chooser
	var abc = function(by,dir)
	{
		if (dir != "ascending" && dir != "descending") return null;
		switch (by)
		{
			case "flag":
				if (dir == "descending") return FlagDown;
				else return FlagUp;
			case "title":
				if (dir == "descending") return TitleDown;
				else return TitleUp;
			case "read":
				if (dir == "descending") return ReadDown;
				else return ReadUp;
			case "date":
				if (dir == "descending") return DateDown;
				else return DateUp;
		}
	return null;
	}

// sorters
	var FlagUp = function(a,b)
	{
		var tmp = ((model.get(itemFeed[b]).flags[itemIndex[b]] & 0x04) - (model.get(itemFeed[a]).flags[itemIndex[a]] & 0x04));
		if (tmp > 0) return 1;
		else if (tmp < 0) return -1;
		else return (a < b) ? -1 : 1;
	}
// when gecko sort stable, can replace FlagUp body with the following line 
//		{ return ((model.get(itemFeed[b]).flags[itemIndex[b]] & 0x04) - (model.get(itemFeed[a]).flags[itemIndex[a]] & 0x04)); };
	var FlagDown = function(a,b)
	{
		var tmp = ((model.get(itemFeed[b]).flags[itemIndex[b]] & 0x04) - (model.get(itemFeed[a]).flags[itemIndex[a]] & 0x04));
		if (tmp > 0) return -1;
		else if (tmp < 0) return 1;
		else return (a < b) ? -1 : 1;
	}
// when stable use next line
// 		{ return FlagUp(b,a); };

	var TitleUp = function(a,b)  // don't worry about ties
	{ return (items[a].title.toLowerCase() < items[b].title.toLowerCase() ? -1 : 1); };
	var TitleDown = function(a,b) { return TitleUp(b,a); };

	var ReadUp = function(a,b)
	{
		var tmp = ((model.get(itemFeed[b]).flags[itemIndex[b]] & 0x01) - (model.get(itemFeed[a]).flags[itemIndex[a]] & 0x01));
		if (tmp > 0) return 1;
		else if (tmp < 0) return -1;
		else return (a < b) ? -1 : 1;
	}
// when stable use next line
//		{ return ((model.get(itemFeed[b]).flags[itemIndex[b]] & 0x01) - (model.get(itemFeed[a]).flags[itemIndex[a]] & 0x01)); };
	var ReadDown = function(a,b)
	{
		var tmp = ((model.get(itemFeed[b]).flags[itemIndex[b]] & 0x01) - (model.get(itemFeed[a]).flags[itemIndex[a]] & 0x01));
		if (tmp > 0) return -1;
		else if (tmp < 0) return 1;
		else return (a < b) ? -1 : 1;
	}
// when stable use next line
// 		{ return ReadUp(b,a); };

	var DateUp = function(a,b)  // don't worry about ties
	{ return (items[a].date < items[b].date ? -1 : 1); };
	var DateDown = function(a,b) { return DateUp(b,a); };

// movers
	var tmpLoad = function(open,j,tmpA,tmpIF,tmpI,tmpF)
	{
		tmpA[open] = items[j];
		tmpIF[open] = itemFeed[j];
		tmpI[open] = itemIndex[j];
		tmpF[open] = feed.flags[itemIndex[j]];  // only used in feed sort, 
																						// so feed exists
	}

	var tmpUnload = function(j,open,tmpA,tmpIF,tmpI,tmpF)
	{
		items[j] = tmpA[open];
		if (type == 1)  // feed
		{
			feed.set(j,items[j]);
			feed.flags[j] = tmpF[open];
		}
		else  // group or category
		{
			itemFeed[j] = tmpIF[open];
			itemIndex[j] = tmpI[open];
		}
	}

// the sort function
	var sorter = abc(by,dir);
	var N = items.length;
	var dummy = new Array(N);
	var invdum = new Array(N);
	var done = new Array(N);
	var tmpA = new Array();
	var tmpIF = new Array();
	var tmpI = new Array();
	var tmpF = new Array();
	for (var i=0; i<N; i++)
	{
		dummy[i] = i;
		done[i] = false;
	}
	dummy.sort(sorter);
	for (i=0; i<N; i++)
		invdum[dummy[i]] = i;
	var j, open;
	for (i=0; i<N; i++)
		if (!done[i])
		{
			j = invdum[i];
			tmpLoad(0,i,tmpA,tmpIF,tmpI,tmpF);
			open = 1;
			while (j != i)
			{
				tmpLoad(open,j,tmpA,tmpIF,tmpI,tmpF);
				open = 1 - open;
				tmpUnload(j,open,tmpA,tmpIF,tmpI,tmpF);
				done[dummy[j]] = true;
				j = invdum[j];
			}
			tmpUnload(j,1-open,tmpA,tmpIF,tmpI,tmpF);
			done[dummy[j]] = true;
		}
}
